;;; 
;;; Virtual Disk Drive Project	- Nov 11, 2003
;;;
	
#include "main.h"
#include "vd.h"
#include "utility.h"
#include "track.h"
	
PROG1	CODE
	global	HeadMove
	
;;;*******************************************************************
;;; NAME:	HeadMove()
;;;
;;; DESCR:	Implement a head move when it is noticed by HeadCheck.
;;;
;;; ARGS:	
;;;
;;; RETURNS:	
;;;
;;; NOTES:	- It really doesn't matter how many cycles this thing
;;;		  takes, but if your curious:
;;;		- the direction line is checked at the beginning of
;;;		  this routine, although it is possible that it
;;;		  changes between when the pulse hit and now...but I
;;;		  sincerely doubt it (I haven't check to see for sure).
;;;		- doesn't return until the head move line is lowered
;;;*******************************************************************
HeadMove:
	;; really need to simply check where we are (relative block location)
	;; and restore that location when we're done...
	;; subtract CURBASE_LO from MEMBLOCKLO to get the offset
	;; then use the offset to get back to where we were after the move

		;; 	(do it here)
	
		SkipIfLow	HEAD_DIR	; (0)
		goto		HeadMoveNext

HeadMovePrev:	call		PrevTrack
		goto		HeadMoveDone

HeadMoveNext:	call		NextTrack

HeadMoveDone:	movf		CURTRACK	; (1) just checking for track 0
		skpnz				; (2)
		Raise		TRACK0		; (3) bring up track 0 line

		movf		CURTRACK	; (4) just checking for track 0
		skpz				; (5)
		Lower		TRACK0		; (6) bring down track 0 line

	;; ensure that the head move indicator line goes low before
	;; returning from this routine

HeadMoveLoop:	SkipIfLow	HEAD_MOVE	; (0)
		goto		HeadMoveLoop
	
		return

;;; =======================================================================
;;; =======================================================================

	END
